clear all;
close all;

A = importdata('0T_0.00_Sweep_Up.dat');
Data(:,1) = A(:,2);
Data(:,2) = A(:,3);

A = importdata('0.5T_Temperature_Sweep.dat');
Data(:,3) = A(:,2);
Data(:,4) = A(:,3);

A = importdata('1T_Temperature_Sweep.dat');
Data(:,5) = A(:,2);
Data(:,6) = A(:,3);

A = importdata('1.5T_Temperature_Sweep.dat');
Data(:,7) = A(:,2);
Data(:,8) = A(:,3);

A = importdata('2T_Temperature_Sweep.dat');
Data(:,9) = A(:,2);
Data(:,10) = A(:,3);

A = importdata('2.5T_Temperature_Sweep.dat');
Data(:,11) = A(:,2);
Data(:,12) = A(:,3);

A = importdata('3T_Temperature_Sweep.dat');
Data(:,13) = A(:,2);
Data(:,14) = A(:,3);

A = importdata('3.5T_Temperature_Sweep.dat');
Data(:,15) = A(:,2);
Data(:,16) = A(:,3);

A = importdata('4T_Temperature_Sweep.dat');
Data(:,17) = A(:,2);
Data(:,18) = A(:,3);

A = importdata('4.5T_Temperature_Sweep.dat');
Data(:,19) = A(:,2);
Data(:,20) = A(:,3);

figure;
hold on;
box on;
for i = 1:10
    plot(Data(:,(i*2)-1),Data(:,(i*2)),'b','linewidth',3);
end
set(gca,'fontsize',15,'fontname','times');
set(gcf,'color','w');
xlabel('\it Temperature (K)','fontsize',20,'fontname','times');
ylabel('\it Field (T)','fontsize',20,'fontname','times');
box on;
title('Temperature Sweeps in Field Parrallel to c');
Legend = cell(2,1);
Legend{1} = strcat('\it R_{\rm{xx}} \rm up');
legend(Legend, 'location', 'NorthWest');
set(legend,'FontSize',20);
legend show Location NorthWest
legend boxoff
hold off;
